/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectsConstants;
import com.ibm.hwmca.fw.util.TaskLegacyOrder;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TaskNode
implements Serializable {
    private static final Set TABLE_PROPERTIES = new HashSet(4);
    private static transient MyComparator comparator;
    private String id;
    private UIInfo uIInfo;
    private TaskUrl url;
    private boolean isTask;
    private boolean isDisruptive;
    private List children;

    protected TaskNode() {
        this.children = new SortedList(TaskNode.getComparator());
    }

    public TaskNode(String id, UIInfo uIInfo, TaskUrl url, boolean isTask, boolean isDisruptive) {
        this.id = id;
        this.uIInfo = uIInfo;
        this.url = url;
        this.isTask = isTask;
        this.children = new SortedList(TaskNode.getComparator());
    }

    public TaskNode(String id, UIInfo uIInfo, TaskUrl url) {
        this(id, uIInfo, url, false, false);
    }

    public TaskNode(String id, UIInfo uIInfo) {
        this(id, uIInfo, null);
    }

    public String getId() {
        return this.id;
    }

    public void addChild(TaskNode childNode) throws IllegalStateException {
        if (this.isTask) {
            throw new IllegalStateException("This node is a task, and can not have any children!");
        }
        this.children.add(childNode);
    }

    public void addChildren(List childNodes) throws IllegalStateException {
        if (this.isTask) {
            throw new IllegalStateException("This node is a task, and can not have any children!");
        }
        this.children.addAll(childNodes);
    }

    public List getChildren() {
        return this.children;
    }

    public String getName() {
        return this.uIInfo.getName();
    }

    public String getName(Locale locale) {
        return this.uIInfo.getName(locale);
    }

    public String getCaption() {
        return this.uIInfo.getCaption();
    }

    public String getCaption(Locale locale) {
        return this.uIInfo.getCaption(locale);
    }

    public String getImageUrl() {
        return this.uIInfo.getImageURL();
    }

    public String getImageName() {
        return this.uIInfo.getImageName();
    }

    public void setUrl(TaskUrl url) {
        this.url = url;
    }

    public TaskUrl getUrl() {
        return this.isTask() ? this.url : null;
    }

    public String getUrlString() {
        return this.isTask() ? this.url.toString() : null;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public boolean isDisruptiveTask() {
        return this.isTask && this.isDisruptive;
    }

    public Map getTableProperties(UserObject userObj) {
        Locale locale = userObj.getLocale();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String key = null;
        Iterator i = TABLE_PROPERTIES.iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (key.equals("Name")) {
                properties.put(key, new NameTableCellBean(this.getName(locale), this.isTask() ? this.getUrlString() : null, this.getImageUrl(), this.getImageName(), this.getId()));
                continue;
            }
            if (!key.equals("Caption")) continue;
            properties.put(key, this.getCaption(locale));
        }
        properties.put("id", this.getId());
        return properties;
    }

    public TaskNode getNoChildrenClone() {
        TaskNode clone = new TaskNode();
        clone.id = this.id;
        clone.uIInfo = this.uIInfo;
        clone.url = this.url == null ? null : (TaskUrl)this.url.clone();
        clone.isTask = this.isTask;
        clone.isDisruptive = this.isDisruptive;
        return clone;
    }

    public TaskNode getNoChildrenNoUrlClone() {
        TaskNode clone = new TaskNode();
        clone.id = this.id;
        clone.uIInfo = this.uIInfo;
        clone.isTask = this.isTask;
        clone.isDisruptive = this.isDisruptive;
        return clone;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            return this.id.equals(((TaskNode)obj).getId());
        }
        catch (ClassCastException ccEx) {
            return false;
        }
    }

    public int hashCode() {
        return Integer.decode("0x" + this.id);
    }

    public String toString() {
        return this.uIInfo.getName();
    }

    public static Comparator getComparator() {
        return comparator;
    }

    static {
        TABLE_PROPERTIES.add("Name");
        TABLE_PROPERTIES.add("Caption");
        comparator = new MyComparator();
    }

    private static class MyComparator
    implements Comparator,
    Serializable {
        private static final TaskLegacyOrder GROUP_ORDER = new TaskLegacyOrder();

        public int compare(Object obj1, Object obj2) {
            TaskNode node1 = (TaskNode)obj1;
            TaskNode node2 = (TaskNode)obj2;
            if (node1.isTask() != node2.isTask()) {
                return node1.isTask() ? 1 : -1;
            }
            if (node1.isTask()) {
                int result = node1.getName().compareTo(node2.getName());
                if (result == 0) {
                    result = node1.getId().compareTo(node2.getId());
                }
                return result;
            }
            HashSet<String> ids = new HashSet<String>(2);
            ids.add(node1.getId());
            ids.add(node2.getId());
            String[] sorted = GROUP_ORDER.sortTaskGroups(ControllerServlet.getUIObjectsReader().getProperties(ids, UIObjectsConstants.ALL_PROPERTY_NAMES, Locale.getDefault()));
            return sorted[0].equals(node1.getId()) ? -1 : 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyComparator;
        }
    }
}

